package aufgaben.aufgabe7;

import java.util.Random;

public class Main
{

    public static void main(String[] args)
    {
        System.out.printf("%n%n---------------- Name-Objekte --------------%n%n");
        Name n1 = new Name("FIW");
        Name n2 = new Name("AI");
        Name n3 = new Name("IMI");

        System.out.println(n1.toString());
        System.out.println(n2.toString());
        System.out.println(n3.toString());
        System.out.println();
        System.out.println("FIW > AI  ? (true  == " + n1.isBigger(n2) + ")");
        System.out.println("FIW > IMI ? (false == " + n1.isBigger(n3) + ")");

        System.out.printf("%n%n---------------- Studentin --------------%n%n");
        Studentin[] studis = new Studentin[40];
        Random r = new Random();
        for (int index = 0; index < 40; index++) {
            studis[index] = switch(r.nextInt(5)) {
                case 0 -> new Studentin("FIW");
                case 1,2 -> new Studentin("AI");
                case 3,4 -> new Studentin("IMI");
                default -> throw new IllegalStateException("Unexpected value: " + r.nextInt(5));
            };
            System.out.println(studis[index].toString());
        }

        System.out.printf("%n%n---------------- Studiengaenge --------------%n%n");
        SG fiw = new SG(studis, "FIW");
        System.out.println(fiw.toString());
        fiw.sort(true);
        System.out.println(fiw.toString());
        fiw.sort(false);
        System.out.println(fiw.toString());

        SG ai = new SG(studis, "AI");
        System.out.println(ai.toString());
        ai.sort(true);
        System.out.println(ai.toString());
        ai.sort(false);
        System.out.println(ai.toString());

        SG imi = new SG(studis, "IMI");
        System.out.println(imi.toString());
        imi.sort(true);
        System.out.println(imi.toString());
        imi.sort(false);
        System.out.println(imi.toString());

        System.out.printf("%n------------ Studiengaenge (FIW) ---------------%n%n");
        Studentin fiwBesterAbschluss = fiw.besterAbschluss();
        if(fiwBesterAbschluss != null) System.out.println(fiwBesterAbschluss.toString());
        System.out.printf("durchschnittliche Abschlussnote : %.4f", fiw.durchschnittlicheAbschlussnote());
        Studentin[] nochStudierend = fiw.nochStudierend();
        System.out.printf("%n%n");
        System.out.println("Folgende Studentinnen studieren noch in FIW : ");
        for(int index = 0; index < nochStudierend.length; index++)
        {
            System.out.println("  " + nochStudierend[index].toString());
        }

        System.out.printf("%n------------------- HTW ------------------%n%n");
        HTW htw = new HTW(studis);
        System.out.println(htw.toString());

        Studentin[] nochHTW = htw.nochStudierend();
        System.out.println("aktuell studieren " + nochHTW.length + " Studierende an der HTW : ");
        for (int index = 0; index < nochHTW.length; index++)
        {
            System.out.println(nochHTW[index].toString());
        }
    }
}
