package aufgaben.aufgabe7;

import java.util.Random;

class Studentin {
    private String matrNr;
    private int jahr;
    private double note;
    private int lp;
    private Name sg;

    public Studentin(String sg) {
        this.sg = new Name(sg);
        Random rand = new Random();
        int num = rand.nextInt(10000);
        this.matrNr = String.format("s095%04d", num);
        this.jahr = rand.nextInt(16) + 2009;
        if (this.jahr < 2019) {
            this.lp = 180;
        } else {
            this.lp = (rand.nextInt(36)) * 5;
        }
        this.note = 1.0 + (rand.nextInt(30) * 0.1);
    }

    public String getMatrNr() { return this.matrNr; }
    public double getNote() { return this.note; }
    public int getLp() { return this.lp; }
    public Name getSg() { return this.sg; }
    public int getSemester() {
        return (2025 - this.jahr) * 2 - 1;
    }
    @Override
    public String toString() {
        if (this.lp == 180) {
            return String.format("%8s Absolventin (%d) aus %3s mit 180 LPs. Notendurchschnitt: %.2f",
                    this.matrNr, this.jahr, this.sg, this.note);
        }
        return String.format("%8s %2d.Semester (%d) aus %3s mit %3d LPs. Notendurchschnitt: %.2f",
                this.matrNr, this.getSemester(), this.jahr, this.sg, this.lp, this.note);
    }
}
