package probeklausuren.probeklausur1;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import java.util.*;

import static org.junit.jupiter.api.Assertions.*;

public class Probeklausur1Test
{
    static Circle c0, c1, c2, c3, c4, c5, c6;
    @BeforeAll
    public static void setup()
    {
        c0 = new Circle();
        c1 = new Circle(1);     // c0.equals(c1) == true
        c2 = new Circle(2);
        c3 = new Circle(3);
        c4 = new Circle(4);
        c5 = new Circle(5);

    }

    @Test
    @DisplayName("test union(list1, list2)")
    public void testUnion()
    {
        System.out.printf("%n------------------ tests union(list1, list2) ------------------%n");
        // given
        List<Circle> l1 = List.of(c0, c1, c2);
        List<Circle> l2 = List.of(c3, c4, c5);
        List<Circle> l3 = List.of(c0, c1, c2);
        List<Circle> l4 = List.of(c0, c1, c3);
        List<Circle> l5 = List.of();

        // when
        List<Circle> list1 = Probeklausur1.union(l1, l2);
        List<Circle> list2 = Probeklausur1.union(l3, l4);
        List<Circle> list3 = Probeklausur1.union(l1, l3);
        List<Circle> list4 = Probeklausur1.union(l2, l4);
        List<Circle> list5 = Probeklausur1.union(l4, l5);

        // then
        List<Circle> expected1 = List.of(c0, c2, c3,  c4, c5);
        List<Circle> expected2 = List.of(c0, c2, c3);
        List<Circle> expected3 = List.of(c0, c2);
        List<Circle> expected4 = List.of(c0, c3,  c4, c5);
        List<Circle> expected5 = List.of(c0, c3);
        assertEquals(expected1, list1, "list should contain circles with radius 1.0, 2.0, 3.0, 4.0 and 5.0, only");
        assertEquals(expected2, list2, "list should contain circles with radius 1.0, 2.0 and 3.0, only");
        assertEquals(expected3, list3, "list should contain circles with radius 1.0 and 2.0, only");
        assertEquals(expected4, list4, "list should contain circles with radius 1.0, 3.0, 4.0 and 5.0, only");
        assertEquals(expected5, list5, "list should contain circles with radius 1.0 and 3.0, only");
    }

    @Test
    @DisplayName("test createMap(list)")
    public void testCreateMap()
    {
        System.out.printf("%n------------------ tests createMap(list) ---------------------%n");
        // given
        List<Circle> l1 = List.of(c0, c1, c2, c3, c4, c5, c0, c1, c2, c3, c4, c5, c4, c5, c0);
        List<Circle> l2 = List.of(c0, c1);

        // when
        Map<Double, List<Circle>> map1 = Probeklausur1.createMap(l1);
        Map<Double, List<Circle>> map2 = Probeklausur1.createMap(l2);

        // then
        Map<Double, List<Circle>> expected1 = new HashMap<>();
        expected1.put(Math.PI * Math.pow(1.0, 2), List.of(c0, c1, c0, c1, c0));
        expected1.put(Math.PI * Math.pow(2.0, 2), List.of(c2, c2));
        expected1.put(Math.PI * Math.pow(3.0, 2), List.of(c3, c3));
        expected1.put(Math.PI * Math.pow(4.0, 2), List.of(c4, c4, c4));
        expected1.put(Math.PI * Math.pow(5.0, 2), List.of(c5, c5, c5));
        assertEquals(expected1, map1, "click on \"Click to see difference\" in IntelliJ");

        Map<Double, List<Circle>> expected2 = new HashMap<>();
        expected2.put(Math.PI * Math.pow(1.0, 2), List.of(c0, c1));
        assertEquals(expected2, map2, "click on \"Click to see difference\" in IntelliJ");
    }

    @Test
    @DisplayName("test addListToMap(list)")
    public void testAddListToMap()
    {
        System.out.printf("%n------------------ tests addListToMap(list) ---------------------%n");
        // given
        Map<Double, List<Circle>> map1 = new HashMap<>();
        List<Circle> l1 = new ArrayList<>();
        l1.add(c0);
        l1.add(c1);
        map1.put(Math.PI * Math.pow(1.0, 2), l1);
        List<Circle> l2 = new ArrayList<>();
        l2.add(c2);
        map1.put(Math.PI * Math.pow(2.0, 2), l2);
        List<Circle> l3 = new ArrayList<>();
        l3.add(c3);
        map1.put(Math.PI * Math.pow(3.0, 2), l3);
        List<Circle> l4 = new ArrayList<>();
        l4.add(c4);
        l4.add(c4);
        map1.put(Math.PI * Math.pow(4.0, 2), l4);
        List<Circle> list1 = List.of(c0, c1, c2, c3, c4, c5);

        Map<Double, List<Circle>> map2 = new HashMap<>();
        List<Circle> l5 = new ArrayList<>();
        l5.add(c0);
        l5.add(c1);
        map2.put(Math.PI * Math.pow(1.0, 2), l5);
        List<Circle> list2 = List.of(c0, c1, c2);

        // when
        Probeklausur1.addListToMap(map1, list1);
        Probeklausur1.addListToMap(map2, list2);

        // then
        Map<Double, List<Circle>> expected1 = new HashMap<>();
        expected1.put(Math.PI * Math.pow(1.0, 2), List.of(c0, c1, c0, c1));
        expected1.put(Math.PI * Math.pow(2.0, 2), List.of(c2, c2));
        expected1.put(Math.PI * Math.pow(3.0, 2), List.of(c3, c3));
        expected1.put(Math.PI * Math.pow(4.0, 2), List.of(c4, c4, c4));
        expected1.put(Math.PI * Math.pow(5.0, 2), List.of(c5));
        assertEquals(expected1, map1, "click on \"Click to see difference\" in IntelliJ");

        Map<Double, List<Circle>> expected2 = new HashMap<>();
        expected2.put(Math.PI * Math.pow(1.0, 2), List.of(c0, c1, c0, c1));
        expected2.put(Math.PI * Math.pow(2.0, 2), List.of(c2));
        assertEquals(expected2, map2, "click on \"Click to see difference\" in IntelliJ");
    }

    @Test
    @DisplayName("test getFirstCircleOfKey(map, key)")
    public void testGetFirstCircleOfKey()
    {
        System.out.printf("%n------------------ tests getFirstCircleOfKey(map, key) ---------------------%n");
        // given
        Map<Double, List<Circle>> map = new HashMap<>();
        map.put(Math.PI * Math.pow(1.0, 2), List.of(c0, c1));
        map.put(Math.PI * Math.pow(2.0, 2), List.of(c2));
        map.put(Math.PI * Math.pow(3.0, 2), List.of(c3));
        map.put(Math.PI * Math.pow(4.0, 2), List.of(c4));
        map.put(Math.PI * Math.pow(5.0, 2), List.of(c5));

        //when
        int key1 = 78;
        int key2 = 79;
        Circle c = Probeklausur1.getFirstCircleOfKey(map, key1);
        Exception e = assertThrows(IllegalArgumentException.class, () -> Probeklausur1.getFirstCircleOfKey(map, key2));

        // then
        assertNotNull(c, "Circle should not be null");
        assertEquals(c5, c, "Circle should have radius=5.0");
        assertEquals("key 79 not found", e.getMessage());
    }

    @Test
    @DisplayName("test getFirstCircleOfRadius(map, radius)")
    public void testGetFirstCircleOfRadius()
    {
        System.out.printf("%n------------------ tests getFirstCircleOfRadius(map, radius) ---------------------%n");
        // given
        Map<Double, List<Circle>> map = new HashMap<>();
        map.put(Math.PI * Math.pow(1.0, 2), List.of(c0, c1));
        map.put(Math.PI * Math.pow(2.0, 2), List.of(c2));
        map.put(Math.PI * Math.pow(3.0, 2), List.of(c3));
        map.put(Math.PI * Math.pow(4.0, 2), List.of(c4));
        map.put(Math.PI * Math.pow(5.0, 2), List.of(c5));

        //when
        double radius1 = 5.0;
        double radius2 = 6.0;
        Optional<Circle> o1 = Probeklausur1.getFirstCircleOfRadius(map, radius1);
        Optional<Circle> o2 = Probeklausur1.getFirstCircleOfRadius(map, radius2);

        // then
        assertTrue(o1.isPresent(), "Optional should not be empty");
        assertTrue(o2.isEmpty(), "Optional should be empty");
        assertEquals(c5, o1.get(), "Circle should have radius=5.0");
    }

    @Test
    @DisplayName("test Circle is Comparable")
    public void testCircleIsComparable()
    {
        System.out.printf("%n------------------ test Circle is Comparable ---------------------%n");
        // given
        Circle c1 = new Circle(1.0);
        Circle c2 = new Circle(2.0);
        Circle c3 = new Circle(1.0);

        if(c1 instanceof Comparable co1 && c2 instanceof Comparable co2 && c3 instanceof Comparable co3) {
            //when
            int result1 = co1.compareTo(co2);
            int result2 = co2.compareTo(co1);
            int result3 = co3.compareTo(co1);

            // then
            assertTrue(c1 instanceof Comparable, "Circle should be Comparable");
            assertTrue(result1 < 0, "if smaller then compareTo < 0");
            assertTrue(result2 > 0, "if bigger then compareTo > 0");
            assertTrue(result3 == 0, "if equals then compareTo == 0");
        } else {
            fail("Circle is not comparable");
        }
    }

    @Test
    @DisplayName("test createSortedListOfCircles(list)")
    public void testCreateSortedListOfCircles()
    {
        System.out.printf("%n------------------ tests createSortedListOfCircles(list) ---------------------%n");
        // given
        List<Circle> l1 = List.of(c0, c1, c2, c3, c4, c5, c0, c1, c2, c3, c4, c5, c4, c5, c0);

        // when
        List<Circle> sorted1 = Probeklausur1.createSortedListOfCircles(l1);

        // then
        for(int i = 0; i < sorted1.size() -1; i++) {
            if(sorted1.get(i) instanceof Comparable co1 && sorted1.get(i+1) instanceof Comparable co2) {
                assertTrue(co1.compareTo(co2) <= 0, "list should be sorted");
            } else {
                fail("Circle is not comparable");
            }
        }
    }

    @Test
    @DisplayName("test createSortedListOfCirclesEvenRadiiFirst(list)")
    public void testCreateSortedListOfCirclesEvenRadiiFirst()
    {
        System.out.printf("%n------------------ tests createSortedListOfCirclesEvenRadiiFirst(list) ---------------------%n");
        // given
        List<Circle> l1 = List.of(c0, c1, c2, c3, c4, c5, c0, c1, c2, c3, c4, c5, c4, c5, c0);
        List<Circle> sorted = List.of(c2, c2, c4, c4, c4, c0, c1, c0, c1, c0, c3, c3, c5, c5, c5);
        // when
        List<Circle> sorted1 = Probeklausur1.createSortedListOfCirclesEvenRadiiFirst(l1);

        // then
        for(int i = 0; i < sorted1.size(); i++) {
            assertTrue(sorted1.get(i).equals(sorted.get(i)), "list should be sorted, even radii first");
        }
    }
}
